<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Uploadimage;
use DB;
use Intervention\Image\Facades\Image;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function uploadImage()
    {
        return view('setting.upload');
    }

    public function saveImage(Request $request)
    {
        if($request->hasFile('file')) {
            $image = $request->file('file');
            $imageName = $image->getClientOriginalName();
            $image->move(public_path('upload'),$imageName);

            // // Create a thumbnail version
            $image = Image::make(public_path('upload/'.$imageName));
            $image->resize(200, 200); // Provide the desired width and height for the resized image
            $thumbnailName = 'thumbnail'.'_'.$imageName;
            $image->save(public_path('upload/'.$thumbnailName)); // Save the resized image


        }else{
            $imageName = null;
            $thumbnailName  = null;
        }



        $img = new uploadImage;
        $img->file_thumbnail = $thumbnailName;
        $img->file = $imageName;

        $img->save();

        return response()->json($img);
    }

    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
