@extends('layouts.master')
@section('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.2/min/dropzone.min.css" />
@endsection
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4">Upload File</h4>
        <form enctype="multipart/form-data">
            @csrf
        <div class="row">
            <div class="col-12">
                <label for="" class="mb-3">File Name :</label>
                {{-- <input type="text" class="form-control mb-3" id="" name="file" > --}}
                <div class="file-upload-card">
                
                    <div id="my-dropzone1" class="dropzone"></div>
                </div>
                   
            </div>
        </div>
        </form>

    </div>
    <!-- / Content -->
@endsection

@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/dropzone.min.js"></script>


<script>
    
   Dropzone.autoDiscover = false;
    $(function() {
        
    //Dropzone.options.myDropzone1 = {
        var csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        //var order_id = "{{request('order_id')}}";

      $("#my-dropzone1").dropzone({
        paramName: "file", // The name attribute of your file input
        maxFilesize: 10, // Maximum file size (in MB)
        addRemoveLinks: true,
        resizeWidth: 1080,
        //resizeHeight: 600,
        resizeMethod: "contain",
        resizeQuality: 0.8,
        maxFiles: 1000,
        dictDefaultMessage: "Drop files here or click to upload",
        url:"{{url('setting/saveimage')}}",
        dictResponseError: 'Error uploading file!',
        headers: {
            'X-CSRF-Token': csrfToken
        },
        acceptedFiles: ".jpeg,.jpg,.png,.webp",
        maxfilesexceeded: function(file) {
            this.removeAllFiles();
            this.addFile(file);
        },
        renameFilename: function(file , name) {

        //console.log(file);
          // var rcid = $('.po_no').val();
          var threedigitsrandom = Math.floor(10000 + Math.random() * 90000);

          // //return file.renameFilename = rcid + "-" + name.name + "." + file.split('.').pop();
          return file.renameFilename = threedigitsrandom + "-" + name.name ;
        },
       removedfile: function(file) {
                        var name = file.upload.filename;

                        console.log(name);
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({

                            type: 'POST',
                            url: "{{ url('setting/imagedelete') }}" ,
                            data: {
                                file: name
                            },
                            success: function(data) {
                                console.log("File has been successfully removed!!");
                            },
                            error: function(e) {
                                console.log(e);
                            }
                        });
                        var fileRef;
                        return (fileRef = file.previewElement) != null ?
                            fileRef.parentNode.removeChild(file.previewElement) : void 0;
                    },

                    // success: function(file, response) {
                    //     return file.previewElement.classList.add("dz-success");

                    //     console.log(response);
                    // },
                    init: function() {
                        this.on("success", function(file, response) {
                            
                            // $('#other_file1').val(response.filename);
                            // var newImageUrl1 = "{{ url('upload') }}"+"/"+response.filename;
                            // $('#showimg1').attr("src", newImageUrl1);

                            return file.previewElement.classList.add("dz-success");

                        });
                    },


      });

    })
</script>

@endsection
